
/*----------------------------------------------------------------------------
 * Name: bleprocess.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 *----------------------------------------------------------------------------*/
#include	"string.h"
#include	"variable.h"
#include	"bleprocess.h"

extern u8	TransmitData[];
extern u8	ReciveData[];

/*--- set crystal C-LOAD ---*/
#if (_CLOAD_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetCrystalCload =
{
	BCI_CMD_PKG,				//head type
	3+1,							//length
	0x00,							//Flag
	BCI_CLOAD_SET,				//opcode 
	_CLOAD_VALUE_				//parameter
};
#endif
/*--- set TX power ---*/
#if (_TXPWR_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetTxPower =
{
	BCI_CMD_PKG,				//head type
	3+1,							//length
	0x00,							//Flag
	BCI_TX_POWER,				//opcode 
	_TX_POWER_VALUE_			//parameter
};
#endif

/*--- set BT device name ---*/
#if (_BDNAME_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetDeviceName =
{
	BCI_CMD_PKG,				//head type
	3+6,							//length
	0x00,							//Flag
	BCI_DEV_NAME,				//opcode 
	{'B','M','7','7','0','1'}			//parameter
};
#endif

/*--- set Advertising Data ---*/
#if (_ADV_DATA_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetAdvData =
{
	BCI_CMD_PKG,				//head type
	3+15,							//length
	UPDAE_AUTO_NAME,			//Flag=auto add device name
	BCI_ADV_DATA,				//opcode 
	{
		/* flag */
		2,0x01,0x06,
		/* Manufacturer Specific Data */
		11,0xFF,0xFF,0xFF,
		'B','e','s','t','C','o','m','m'
	},	
};
#endif

/*--- Set Scan Response Data ---*/
#if (_SCAN_DATA_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetScanData =
{
	BCI_CMD_PKG,				//head type
	3+12,							//length
	0x00,							//Flag
	BCI_SCAN_DATA,				//opcode 
	{
		/* complete List of 16-bit Service Class UUIDs */
		11,0x03,0x00,0x18,0x01,0x18,0x0A,0x18,0x0F,0x18,0xF0,0xFF
	}
};
#endif

/*--- set Advertising interval ---*/
#if (_ADV_INTV_CFG_ENABLE_ == 1)
const tBCI_PACKAGE	BLE_SetAdvInterval =
{
	BCI_CMD_PKG,				//head type
	3+5,							//length
	0x00,							//Flag
	BCI_ADV_INTV,				//opcode 
	{
		((u16)(_ADV_INTV_MIN_VALUE_/0.625)) & 0xFF,		
		((u16)(_ADV_INTV_MIN_VALUE_/0.625)) >> 8,
		((u16)(_ADV_INTV_MAX_VALUE_/0.625)) & 0xFF,
		((u16)(_ADV_INTV_MAX_VALUE_/0.625)) >> 8,
		0x07									// bit0=CH37,bit1=CH38,bit2=CH39
	}
};
#endif

/*--- set feature auto send status event ---*/
const tBCI_PACKAGE	BLE_SetFeatureState =
{
	BCI_CMD_PKG,				//head type
	3+4,							//length
	FEATURE_SET,				//Flag
	BCI_FEATURE_CTRL,			//opcode 
	{
		(u32)FEATURE_STATUS_SETUP & 0xFF,
		((u32)FEATURE_STATUS_SETUP >> 8) & 0xFF,
		((u32)FEATURE_STATUS_SETUP >> 16) & 0xFF,
		((u32)FEATURE_STATUS_SETUP >> 24) & 0xFF,
	}
};

BLE_OPERATE	BLEOperate;

static u8	ModifyItem;
static u8	EventRspOpCode;
static u8	NextStepStatus;
/*----------------------------------------------------------------------------*/
/*	 BLE power up mode                                                        	*/
/*----------------------------------------------------------------------------*/
void BLE_EnterPowerUp(void)
{
	BLEOperate.F.V = 0;
	BLEOperate.TimeCounter = 0;
	BLEOperate.State = _BLE_START_;
}
/*----------------------------------------------------------------------------*/
/*	 BLE power save mode                                                     	*/
/*----------------------------------------------------------------------------*/
void BLE_EnterPowerSave(void)
{
	BLEOperate.State = _BLE_ENTER_PWR_SAVE_;	
}
/*----------------------------------------------------------------------------*/
/*	 BLE timer process                                                         */
/*----------------------------------------------------------------------------*/
void BLE_TimerProcess(void)
{
   if(BLEOperate.TimeCounter != 0)
   {
   	BLEOperate.TimeCounter--;
   	if(BLEOperate.TimeCounter == 0) BLEOperate.F.B.TmCntFinish = TRUE;
   }
}
/*------------------------------------------------------------------------------
* Function Name : BLE_TransceiveToEventRsp
* Description   : 
* Input         :
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void BLE_TransceiveToEventRsp(u8 timeout,u8 next)
{
	BLEOperate.F.B.TmCntFinish = FALSE;
	BLEOperate.TimeCounter = timeout;	
	BLEOperate.State = _BLE_EVENT_RESPONSE_;
	NextStepStatus = next;
}
/*------------------------------------------------------------------------------
* Function Name : BLE_ParameterConfigure
* Description   : BLE parmeter 
* Input         :
*				- item : Configured items
* Output        : None
* Return        : None
* 				- TRUE : The configured item is successful
* 				- FALSE: The configured item is empty(indicating the end of the configuration)
------------------------------------------------------------------------------*/
u8 BLE_ParameterConfigure(void)
{	
	switch(ModifyItem)
	{
		case 0:
#if (_CLOAD_CFG_ENABLE_ == 1)
//			BC7701_SetCrystalCload(_CLOAD_VALUE_);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetCrystalCload);
			ModifyItem=1;					//to next modify
			return(BCI_CLOAD_SET);
#endif
		case 1:
#if (_TXPWR_CFG_ENABLE_ == 1)
//			BC7701_SetTxPower(_TX_POWER_VALUE_);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetTxPower);
			ModifyItem=2;					//to next modify
			return(BCI_TX_POWER);			
#endif
		case 2:
#if (_BDNAME_CFG_ENABLE_ == 1)
//			BC7701_SetDeviceName(sizeof(BLE_DeviceName),(u8 *)BLE_DeviceName);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetDeviceName);
			ModifyItem=3;					//to next modify
			return(BCI_DEV_NAME);
#endif
		case 3:
#if (_ADV_DATA_CFG_ENABLE_ == 1)
//			BC7701_SetAdvertisingData(UPDAE_AUTO_NAME,sizeof(BLE_AdvData),(u8 *)BLE_AdvData);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetAdvData);
			ModifyItem=4;					//to next modify
			return(BCI_ADV_DATA);			
#endif
		case 4:
#if (_SCAN_DATA_CFG_ENABLE_ == 1)
//			BC7701_SetScanResponseData(sizeof(BLE_ScanData),(u8 *)BLE_ScanData);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetScanData);
			ModifyItem=5;					//to next modify		
			return(BCI_SCAN_DATA);
#endif		
		case 5:
#if (_ADV_INTV_CFG_ENABLE_ == 1)
//			BC7701_AdvertisingInterval(BLE_AdvInterval.min,BLE_AdvInterval.max,BLE_AdvInterval.map);
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetAdvInterval);
			ModifyItem=6;					//to next modify		
			return(BCI_ADV_INTV);
#endif
		default:
			return(0xFF);
	}
}
/*----------------------------------------------------------------------------*/
/*	 BLE state process                                                         */
/*----------------------------------------------------------------------------*/
void BLE_process(void)
{
	u8 EventValid;
	
	EventValid = BC7701_PackageParserProcess();
	
   switch(BLEOperate.State)
   {
      case _BLE_START_ :
      	BC7701_InterfaceConfigure(BAUD_RATE_9600);
      case _BLE_POWER_UP_ :
			BC7701_RESET_CLR();
			BLEOperate.F.B.TmCntFinish = FALSE;
         BLEOperate.TimeCounter = RESET_DELAY_TIME;     /* delay 10ms */
         BLEOperate.State = _BLE_RESET_DELAY_;
         break;
		case _BLE_RESET_DELAY_:
			if(BLEOperate.F.B.TmCntFinish)
			{
				BC7701_RESET_SET();
				BC7701_HardwareBaudRateDefault(BAUD_RATE_9600);
				BLEOperate.F.B.TmCntFinish = FALSE;
				BLEOperate.TimeCounter = PWRUP_DELAY_TIME;
				BLEOperate.State =	_BLE_PWRUP_DELAY_;				
			}
         break;
		case _BLE_PWRUP_DELAY_ :
			if(BLEOperate.F.B.TmCntFinish)
			{
				BC7701_HardwareBaudRateRelease();
				BLEOperate.State = _BLE_PWRUP_EXAMINE_;
			}
			break;
		case _BLE_PWRUP_EXAMINE_:
			//get BC7701 version date code
			BC7701_TransmitCmdPackage(BCI_VERSION,0x80);
			EventRspOpCode = BCI_VERSION;
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_RECORD_DATECODE_);
			break;
		case _BLE_RECORD_DATECODE_:
			memcpy(BLEOperate.DateCode,BCIPKG(ReciveData)->param,6);
			//get BC7701 BT device address
			BC7701_TransmitCmdPackage(BCI_DEV_ADDRESS,0x00);			
			EventRspOpCode = BCI_DEV_ADDRESS;			
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_RECORD_BDADDR_);			
			break;		
		case _BLE_RECORD_BDADDR_:
			memcpy(&(BLEOperate.BDAddr.adr),BCIPKG(ReciveData)->param,6);
			BLEOperate.BDAddr.type = ((tDEV_ADDR *)(BCIPKG(ReciveData)->param))->type;
			BLEOperate.State = _BLE_CHG_BAUD_RATE_;
			break;
		case _BLE_CHG_BAUD_RATE_:
			ModifyItem = 0;		
#if (_CHG_BAUD_RATE_ENABLE_ == 1)
			BC7701_SetBaudRate(_CHANGE_BAUDRATE_);
			BC7701_TransmitPackage(0);			
			EventRspOpCode = BCI_BAUDRATE;						
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_CHG_UART_BAUD_);
			BLEOperate.F.B.TmDelay = TRUE;
#else
			BLEOperate.F.B.TmDelay = FALSE;
			BLEOperate.State = _BLE_PARAMETER_MODIFY;
#endif
			break;
		case _BLE_CHG_UART_BAUD_:
			if(BLEOperate.F.B.TmDelay) 
			{
				BLEOperate.F.B.TmCntFinish = FALSE;				
				BLEOperate.TimeCounter = CHG_BAUD_DELAY_TIME;
				BLEOperate.F.B.TmDelay = FALSE;
			}			
			if(!BLEOperate.F.B.TmDelay && BLEOperate.F.B.TmCntFinish)
			{
				BC7701_UARTConfigure(_CHANGE_BAUDRATE_);
				BLEOperate.State = _BLE_PARAMETER_MODIFY;
			}
			break;
		case _BLE_PARAMETER_MODIFY:
			if((EventRspOpCode = BLE_ParameterConfigure()) != 0xFF)
			{
//				BC7701_TransmitPackage(0);				
				BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_PARAMETER_MODIFY);
			}
			else
			{
				BLEOperate.State = _BLE_FEATURE_SETUP_;
			}
			break;
		case _BLE_FEATURE_SETUP_:
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BLE_SetFeatureState);
			EventRspOpCode = BCI_FEATURE_CTRL;							
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_ADV_ENABLE_);
			break;
		case _BLE_ADV_ENABLE_:
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BC7701_AdvertiseEnable);
			EventRspOpCode = BCI_ADV_CTRL;			
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_ADV_DELAY_S_);
			break;
		case _BLE_ADV_DELAY_S_:
			BLEOperate.F.B.TmCntFinish = FALSE;						
			BLEOperate.TimeCounter = RF_CALIBRAT_TIME;
			BLEOperate.State = _BLE_ADV_DELAY_E_;
			break;
		case _BLE_ADV_DELAY_E_:
			if(EventValid)
			{
				if((BCIPKG(ReciveData)->opcode == BCI_STATUS) && (BCIPKG(ReciveData)->param[0] & 0x10))
				{
					BLEOperate.TimeCounter = 0;
					BLEOperate.F.B.TmCntFinish = TRUE;
				}
			}
			if(BLEOperate.F.B.TmCntFinish)
			{				
				BLEOperate.State = _BLE_DEEP_SLEEP_;				
			}
			break;
		case _BLE_DEEP_SLEEP_:
#if (_PWRON_FINISH_SLEEP_ == 1)		
			BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BC7701_OperateSleep);
			EventRspOpCode = BCI_OPERATE_MODE;			
			BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_PWR_ON_FINISH_);
#else
				BLEOperate.State = _BLE_PWR_ON_FINISH_;
#endif			
			break;						
		case _BLE_EVENT_RESPONSE_ :
			if(EventValid)
			{
				if(BCIPKG(ReciveData)->opcode == EventRspOpCode)
				{
					if((BCIPKG(ReciveData)->flag & EVTS_CODE_MASK) == EVTS_SUCCESS)
						BLEOperate.State = NextStepStatus;
					else
						BLEOperate.State = _BLE_PWR_ON_ERROR_;					
				}
			}
			else
			{
				if(BLEOperate.F.B.TmCntFinish)
				{
					BLEOperate.State = _BLE_PWR_ON_ERROR_;					
				}
			}
			break;
		case _BLE_PWR_ON_FINISH_:
			BLEOperate.State = _BLE_PWR_ON_SUCCESS_;
			break;									
      case _BLE_PWR_ON_SUCCESS_ :
			if(EventValid)	BLEOperate.F.B.EventValid=TRUE;
         break;
		case _BLE_ENTER_PWR_SAVE_ :
			BC7701_DummyWakeup(DUMMY_WAKEUP_WIDTH);
			BLEOperate.F.B.TmCntFinish = FALSE;
         BLEOperate.TimeCounter = RESET_DELAY_TIME;     /* delay 10ms */
         BLEOperate.State = _BLE_POWER_SAVE_;			
			break;
		case _BLE_POWER_SAVE_ :
			if(BLEOperate.F.B.TmCntFinish)
			{
				BC7701_TransmitPackageConst((tBCI_PACKAGE *)&BC7701_PowerDown);				
				EventRspOpCode = BCI_OPERATE_MODE;
				BLE_TransceiveToEventRsp(EVENT_RETURN_TIME,_BLE_POWER_DOWN_);
			}
			break;                  
		case _BLE_POWER_DOWN_ :
			break;
      case _BLE_PWR_ON_ERROR_ :
         break;
   }
}
